/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs.client.gui.util;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;
import noppes.npcs.CustomNpcs;
import noppes.npcs.client.gui.util.GuiNPCInterface;
import noppes.npcs.client.gui.util.IComponentGui;
import noppes.npcs.client.gui.util.IEditNPC;
import noppes.npcs.client.gui.util.IGuiNpcButton;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiNpcButton
extends GuiButton
implements IComponentGui,
IGuiNpcButton {
    private static final double step = 60.0;
    protected String[] display;
    private int displayValue = 0;
    public int field_146127_k;
    public int layerColor;
    public int txrX = 0;
    public int txrY = 0;
    public int txrW = 0;
    public int txrH = 0;
    public ResourceLocation texture = null;
    public String label = "";
    public boolean dropShadow;
    public boolean hasDefBack;
    public boolean hasSound;
    public boolean isSimple = false;
    public boolean isAnim = false;
    private ItemStack[] itemStacks = null;
    public ItemStack currentStack = ItemStack.field_190927_a;
    public int currentStackID = -1;
    private int ticks = 0;
    private int wait = 0;
    private final List<String> hoverText = new ArrayList<String>();

    public GuiNpcButton(int id, int x, int y, int width, int height, int textureX, int textureY, ResourceLocation texture) {
        this(id, x, y, width, height, "");
        this.display = new String[]{""};
        this.texture = texture;
        this.txrX = textureX;
        this.txrY = textureY;
        this.isSimple = true;
    }

    public GuiNpcButton(int id, int x, int y, int width, int height, int val, String ... display) {
        this(id, x, y, width, height, display.length == 0 ? "" : display[val % display.length]);
        this.display = display;
        this.displayValue = display.length == 0 ? 0 : val % display.length;
    }

    public GuiNpcButton(int id, int x, int y, int width, int height, String label) {
        super(id, x, y, width, height, new TextComponentTranslation(label, new Object[0]).func_150254_d());
        this.field_146127_k = id;
        this.layerColor = 0;
        this.dropShadow = true;
        this.hasSound = true;
    }

    public GuiNpcButton(int id, int x, int y, int width, int height, String label, boolean enabled) {
        this(id, x, y, width, height, label);
        this.field_146124_l = enabled;
    }

    public GuiNpcButton(int id, int x, int y, int width, int height, String[] display, int val) {
        this(id, x, y, width, height, display.length == 0 ? "" : display[val % display.length]);
        this.display = display;
        this.displayValue = display.length == 0 ? 0 : val % display.length;
    }

    public GuiNpcButton(int id, int x, int y, String label) {
        super(id, x, y, new TextComponentTranslation(label, new Object[0]).func_150254_d());
        this.label = label;
        this.field_146127_k = id;
        this.layerColor = 0;
        this.dropShadow = true;
        this.hasSound = true;
    }

    public GuiNpcButton(int id, int x, int y, String[] display, int val) {
        this(id, x, y, display[val]);
        this.display = display;
        this.displayValue = val;
    }

    public GuiNpcButton simple(boolean bo) {
        this.isSimple = bo;
        return this;
    }

    public static void renderString(@Nonnull FontRenderer font, @Nonnull String message, int left, int top, int right, int bottom, int color, boolean showShadow, boolean centered) {
        int textWidth = font.func_78256_a(message);
        int height = (top + bottom - 9) / 2 + 1;
        int width = right - left;
        if (textWidth > width) {
            int centerX = textWidth - width;
            double d0 = (double)System.currentTimeMillis() / 1000.0;
            double d1 = Math.max((double)centerX * 0.5, 3.0);
            double d2 = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d0 / d1)) / 2.0 + 0.5;
            double d3 = 0.0 + d2 * ((double)centerX - 0.0);
            GlStateManager.func_179094_E();
            GL11.glEnable((int)3089);
            Minecraft mc = Minecraft.func_71410_x();
            ScaledResolution sw = new ScaledResolution(mc);
            int i = mc.field_71440_d;
            double d4 = sw.func_78326_a() < mc.field_71443_c ? (double)((int)Math.round((double)mc.field_71443_c / (double)sw.func_78326_a())) : 1.0;
            double d5 = (double)left * d4;
            double d6 = (double)i - (double)bottom * d4;
            double d7 = (double)(right - left) * d4;
            double d8 = (double)(bottom - top) * d4;
            GL11.glScissor((int)((int)d5), (int)((int)d6), (int)Math.max(0, (int)d7), (int)Math.max(0, (int)d8));
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            font.func_175065_a(message, (float)(left - (int)d3), (float)height, color, showShadow);
            GL11.glDisable((int)3089);
            GlStateManager.func_179121_F();
        } else if (centered) {
            width = (left + right) / 2;
            font.func_175065_a(message, (float)width - (float)textWidth / 2.0f, (float)height, color, showShadow);
        } else {
            font.func_175065_a(message, (float)left, (float)height, color, showShadow);
        }
    }

    @Override
    public void render(IEditNPC gui, int mouseX, int mouseY, float partialTicks) {
        this.func_191745_a(Minecraft.func_71410_x(), mouseX, mouseY, partialTicks);
        if (this.field_146123_n && !this.hoverText.isEmpty()) {
            gui.setHoverText(this.hoverText);
        }
    }

    public void func_191745_a(@Nonnull Minecraft mc, int mouseX, int mouseY, float partialTicks) {
        if (!this.field_146125_m) {
            return;
        }
        this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
        int state = this.func_146114_a(this.field_146123_n);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179141_d();
        GlStateManager.func_179140_f();
        if (this.layerColor != 0) {
            GlStateManager.func_179131_c((float)((float)(this.layerColor >> 16 & 0xFF) / 255.0f), (float)((float)(this.layerColor >> 8 & 0xFF) / 255.0f), (float)((float)(this.layerColor & 0xFF) / 255.0f), (float)((float)(this.layerColor >> 24 & 0xFF) / 255.0f));
        }
        if (this.texture == null) {
            mc.func_110434_K().func_110577_a(GuiNPCInterface.MENU_BUTTON);
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            this.func_73729_b(this.field_146128_h, this.field_146129_i, 0, state * 20, this.field_146120_f / 2, Math.min(this.field_146121_g, 20));
            this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i, 200 - this.field_146120_f / 2, state * 20, this.field_146120_f / 2, Math.min(this.field_146121_g, 20));
            if (this.field_146121_g < 20 && this.field_146121_g >= 6) {
                this.func_73729_b(this.field_146128_h, this.field_146129_i + this.field_146121_g - 3, 0, 17 + state * 20, this.field_146120_f / 2, 3);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g - 3, 200 - this.field_146120_f / 2, 17 + state * 20, this.field_146120_f / 2, 3);
            }
            if (this.field_146121_g > 20) {
                int h = this.field_146121_g - 20;
                int j = 0;
                while (h > 0) {
                    this.func_73729_b(this.field_146128_h, this.field_146129_i + 17 + j * 15, 0, state * 20 + 2, this.field_146120_f / 2, Math.min(h, 15));
                    this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + 17 + j * 15, 200 - this.field_146120_f / 2, state * 20 + 2, this.field_146120_f / 2, Math.min(h, 15));
                    h -= 15;
                    ++j;
                }
                this.func_73729_b(this.field_146128_h, this.field_146129_i + this.field_146121_g - 3, 0, state * 20 + 17, this.field_146120_f / 2, 3);
                this.func_73729_b(this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g - 3, 200 - this.field_146120_f / 2, state * 20 + 17, this.field_146120_f / 2, 3);
            }
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            this.func_146119_b(mc, mouseX, mouseY);
        } else {
            if (this.hasDefBack) {
                this.func_73733_a(this.field_146128_h - 1, this.field_146129_i - 1, this.field_146128_h + this.field_146120_f + 1, this.field_146129_i + this.field_146121_g + 1, -14671840, -14671840);
                this.func_73733_a(this.field_146128_h, this.field_146129_i, this.field_146128_h + this.field_146120_f, this.field_146129_i + this.field_146121_g, -6250336, -6250336);
            }
            if (this.isSimple) {
                GlStateManager.func_179094_E();
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GlStateManager.func_179109_b((float)this.field_146128_h, (float)this.field_146129_i, (float)0.0f);
                mc.func_110434_K().func_110577_a(this.texture);
                this.func_73729_b(0, 0, this.txrX, this.txrY + state * this.field_146121_g, this.field_146120_f, this.field_146121_g);
                GlStateManager.func_179121_F();
            } else {
                boolean isPrefabricated = this.txrW == 0;
                int tw = isPrefabricated ? 200 : this.txrW;
                int th = this.txrH == 0 ? 20 : this.txrH;
                float scaleH = (float)this.field_146121_g / (float)th;
                float scaleW = isPrefabricated ? scaleH : (float)this.field_146120_f / (float)tw;
                GlStateManager.func_179094_E();
                GlStateManager.func_179152_a((float)scaleW, (float)scaleH, (float)1.0f);
                GlStateManager.func_179109_b((float)((float)this.field_146128_h / scaleW), (float)((float)this.field_146129_i / scaleH), (float)0.0f);
                mc.func_110434_K().func_110577_a(this.texture);
                GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                if (isPrefabricated) {
                    tw = (int)((float)this.field_146120_f / 2.0f / scaleH);
                    this.func_73729_b(0, 0, this.txrX, this.txrY + state * th, tw, th);
                    this.func_73729_b(tw, 0, this.txrX + 200 - tw, this.txrY + state * th, tw, th);
                } else {
                    this.func_73729_b(0, 0, this.txrX, this.txrY + state * th, tw, th);
                }
                GlStateManager.func_179121_F();
            }
        }
        int color = CustomNpcs.MainColor.getRGB();
        if (this.packedFGColour != 0) {
            color = this.packedFGColour;
        } else if (!this.field_146124_l) {
            color = CustomNpcs.NotEnableColor.getRGB();
        } else if (this.field_146123_n) {
            color = CustomNpcs.HoverColor.getRGB();
        }
        GuiNpcButton.renderString(mc.field_71466_p, this.getDisplayString(), this.field_146128_h + 2, this.field_146129_i, this.field_146128_h + this.getWidth() - 2, this.field_146129_i + this.getHeight(), color, false, true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.itemStacks != null && this.itemStacks.length != 0) {
            this.currentStack = this.itemStacks[0];
            this.currentStackID = 0;
            if (this.itemStacks.length > 1) {
                if (this.wait > 0) {
                    --this.wait;
                } else {
                    this.currentStackID = (int)Math.floor((double)this.ticks % (60.0 * (double)this.itemStacks.length - 1.0) / 60.0);
                    this.currentStack = this.itemStacks[this.currentStackID];
                }
            }
            if (this.currentStack != null && !this.currentStack.func_190926_b()) {
                GlStateManager.func_179094_E();
                RenderHelper.func_74520_c();
                GlStateManager.func_179109_b((float)((float)this.field_146128_h + (float)this.field_146120_f / 2.0f - 8.0f), (float)((float)this.field_146129_i + (float)this.field_146121_g / 2.0f - 8.0f), (float)0.0f);
                mc.func_175599_af().func_180450_b(this.currentStack, 0, 0);
                this.func_73731_b(mc.field_71466_p, "" + this.currentStack.func_190916_E(), 16 - mc.field_71466_p.func_78256_a("" + this.currentStack.func_190916_E()), 9, -1);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            if (this.wait == 0) {
                ++this.ticks;
                if ((double)this.ticks > 60.0 * (double)this.itemStacks.length) {
                    this.ticks = 0;
                }
            }
        }
    }

    @Override
    public int getHeight() {
        return this.field_146121_g;
    }

    @Override
    public void customKeyTyped(char c, int id) {
    }

    @Override
    public void customMouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.func_146116_c(Minecraft.func_71410_x(), mouseX, mouseY);
    }

    @Override
    public void customMouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.func_146118_a(mouseX, mouseY);
    }

    @Override
    public boolean isVisible() {
        return this.field_146125_m;
    }

    @Override
    public int getValue() {
        return this.displayValue;
    }

    @Override
    public String[] getVariants() {
        return this.display;
    }

    @Override
    public int[] getTextureXY() {
        return new int[]{this.txrX, this.txrY};
    }

    @Override
    public void setTextureXY(int x, int y) {
        this.txrX = x;
        this.txrY = y;
    }

    @Override
    public int[] getTextureUV() {
        return new int[]{this.txrW, this.txrH};
    }

    @Override
    public void setTextureUV(int u, int v) {
        this.txrW = u;
        this.txrH = v;
    }

    @Override
    public void setLayerColor(int color) {
        this.layerColor = color;
    }

    @Override
    public String getDisplayString() {
        return this.field_146126_j;
    }

    @Override
    public void setActive(boolean bo) {
    }

    @Override
    public void setHasSound(boolean bo) {
        this.hasSound = bo;
    }

    @Override
    public boolean hasSound() {
        return this.hasSound;
    }

    @Override
    public int getWidth() {
        return this.field_146120_f;
    }

    @Override
    public int getCurrentStackID() {
        return this.currentStackID;
    }

    @Override
    public ItemStack getCurrentStack() {
        return this.currentStack;
    }

    public boolean func_146116_c(@Nonnull Minecraft mc, int mouseX, int mouseY) {
        boolean bo = super.func_146116_c(mc, mouseX, mouseY);
        if (bo && this.display != null && this.display.length != 0) {
            this.displayValue = (this.displayValue + 1) % this.display.length;
            this.setDisplayText(this.display[this.displayValue]);
        }
        return bo;
    }

    public void func_146113_a(@Nonnull SoundHandler soundHandlerIn) {
        if (this.hasSound) {
            super.func_146113_a(soundHandlerIn);
        }
    }

    @Override
    public void resetDisplay(List<String> list) {
        this.display = list.toArray(new String[0]);
        if (this.displayValue >= list.size()) {
            this.displayValue = list.size() - 1;
        }
        if (list.isEmpty()) {
            this.displayValue = 0;
            this.field_146126_j = "";
        } else {
            this.setDisplayText(this.display[this.displayValue]);
        }
    }

    @Override
    public void setDisplay(int value) {
        if (this.display.length == 0) {
            return;
        }
        if (value < 0) {
            value = 0;
        }
        if (value >= this.display.length) {
            value = this.display.length;
        }
        this.displayValue = value;
        this.setDisplayText(this.display[this.displayValue]);
    }

    @Override
    public void setDisplayText(String text) {
        this.field_146126_j = new TextComponentTranslation(text, new Object[0]).func_150254_d();
    }

    @Override
    public void setTexture(ResourceLocation location) {
        this.texture = location;
    }

    @Override
    public void setEnabled(boolean bo) {
        this.field_146124_l = bo;
    }

    @Override
    public void setHasDefaultBack(boolean bo) {
        this.hasDefBack = bo;
    }

    @Override
    public void setIsAnim(boolean bo) {
        this.isAnim = bo;
        this.isSimple = !bo;
    }

    @Override
    public void setTextColor(int color) {
        this.packedFGColour = color;
    }

    @Override
    public void setIsVisible(boolean bo) {
        this.field_146125_m = bo;
    }

    @Override
    public boolean isEnabled() {
        return this.field_146124_l;
    }

    protected int func_146114_a(boolean hovered) {
        if (this.isAnim) {
            if (!this.field_146124_l) {
                return 1;
            }
            return hovered ? (Mouse.isButtonDown((int)0) ? 3 : 2) : 0;
        }
        if (this.isSimple) {
            int i = 0;
            if (!this.field_146124_l) {
                i = 2;
            } else if (hovered) {
                i = Mouse.isButtonDown((int)0) ? 2 : 1;
            }
            return i;
        }
        if (hovered) {
            return (this.field_146124_l ? 1 : 4) + (Mouse.isButtonDown((int)0) ? 1 : 0);
        }
        return this.field_146124_l ? 0 : 3;
    }

    @Override
    public void setStacks(ItemStack ... stacks) {
        if (this.itemStacks != null && stacks != null) {
            this.wait = 160;
        }
        this.itemStacks = stacks;
        this.currentStackID = this.itemStacks != null ? 0 : -1;
        this.ticks = 0;
    }

    @Override
    public ItemStack[] getStacks() {
        return this.itemStacks;
    }

    @Override
    public void setCurrentStackPos(int pos) {
        if (this.itemStacks == null || pos < 0 || pos >= this.itemStacks.length) {
            return;
        }
        this.currentStackID = pos;
        this.wait = 160;
        this.ticks = 0;
    }

    @Override
    public int getID() {
        return this.field_146127_k;
    }

    @Override
    public int[] getCenter() {
        return new int[]{this.field_146128_h + this.field_146120_f / 2, this.field_146129_i + this.field_146121_g / 2};
    }

    @Override
    public void setHoverText(String text, Object ... args) {
        this.hoverText.clear();
        if (text == null || text.isEmpty()) {
            return;
        }
        if (!text.contains("%")) {
            text = new TextComponentTranslation(text, args).func_150254_d();
        }
        if (text.contains("~~~")) {
            text = text.replaceAll("~~~", "%");
        }
        while (text.contains("<br>")) {
            this.hoverText.add(text.substring(0, text.indexOf("<br>")));
            text = text.substring(text.indexOf("<br>") + 4);
        }
        this.hoverText.add(text);
    }

    @Override
    public int getLeft() {
        return this.field_146128_h;
    }

    @Override
    public int getTop() {
        return this.field_146129_i;
    }

    @Override
    public void setLeft(int left) {
        this.field_146128_h = left;
    }

    @Override
    public void setTop(int top) {
        this.field_146129_i = top;
    }

    @Override
    public boolean isHovered() {
        return this.func_146115_a();
    }
}

